/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.snowy;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public interface Snowy {
    public static final Supplier<BiMap<class_2248, class_2248>> NORMAL_TO_SNOWY = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_2246.field_10340, (Object)ModBlocks.SNOWY_STONE.get()).put((Object)class_2246.field_10440, (Object)ModBlocks.SNOWY_STONE_STAIRS.get()).put((Object)class_2246.field_10454, (Object)ModBlocks.SNOWY_STONE_SLAB.get()).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.SNOWY_STONE_WALL.get()).put((Object)class_2246.field_10445, (Object)ModBlocks.SNOWY_COBBLESTONE.get()).put((Object)class_2246.field_10596, (Object)ModBlocks.SNOWY_COBBLESTONE_STAIRS.get()).put((Object)class_2246.field_10351, (Object)ModBlocks.SNOWY_COBBLESTONE_SLAB.get()).put((Object)class_2246.field_10625, (Object)ModBlocks.SNOWY_COBBLESTONE_WALL.get()).put((Object)class_2246.field_10056, (Object)ModBlocks.SNOWY_STONE_BRICKS.get()).put((Object)class_2246.field_10552, (Object)ModBlocks.SNOWY_CHISELED_STONE_BRICKS.get()).put((Object)class_2246.field_10392, (Object)ModBlocks.SNOWY_STONE_BRICK_STAIRS.get()).put((Object)class_2246.field_10131, (Object)ModBlocks.SNOWY_STONE_BRICK_SLAB.get()).put((Object)class_2246.field_10252, (Object)ModBlocks.SNOWY_STONE_BRICK_WALL.get());
        return builder.build();
    });
    public static final Supplier<BiMap<class_2248, class_2248>> SNOWY_TO_NORMAL = Suppliers.memoize(() -> NORMAL_TO_SNOWY.get().inverse());

    public static Optional<class_2680> getSnowy(class_2680 state) {
        return Snowy.getSnowy(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2680> getUnSnowy(class_2680 state) {
        return Snowy.getUnSnowy(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getUnSnowy(class_2248 block) {
        return Optional.ofNullable((class_2248)SNOWY_TO_NORMAL.get().get((Object)block));
    }

    public static Optional<class_2248> getSnowy(class_2248 block) {
        return Optional.ofNullable((class_2248)NORMAL_TO_SNOWY.get().get((Object)block));
    }

    default public boolean interactWithPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        Optional<class_2680> unSnowy = Snowy.getUnSnowy(state);
        if (unSnowy.isPresent() && item instanceof class_1821) {
            level.method_8396(player, pos, class_3417.field_15165, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10477.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
            stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                level.method_8501(pos, unSnowy.get());
                if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)new class_1799((class_1935)class_1802.field_8543));
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return true;
        }
        return false;
    }

    default public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 randomSource) {
        Optional<class_2680> unSnowy = Snowy.getUnSnowy(state);
        for (class_2350 dir : class_2350.values()) {
            if (level.method_8314(class_1944.field_9282, pos.method_10093(dir)) <= 11 || !unSnowy.isPresent()) continue;
            level.method_8501(pos, unSnowy.get());
            class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)dir, (class_1799)new class_1799((class_1935)class_1802.field_8543));
        }
    }

    default public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean isMoving) {
        Optional<class_2680> unSnowy = Snowy.getUnSnowy(state);
        class_2680 neighborState = level.method_8320(neighborPos);
        if (neighborState.method_26227().method_15767(class_3486.field_15517) || neighborState.method_26227().method_15767(class_3486.field_15518) && unSnowy.isPresent()) {
            level.method_8501(pos, unSnowy.get());
            level.method_8396(null, pos, class_3417.field_15165, class_3419.field_15245, 1.0f, 1.0f);
            if (neighborState.method_26227().method_15767(class_3486.field_15518)) {
                level.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 1.0f, 1.0f);
            }
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11206, class_2246.field_10477.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
            }
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10477.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
        }
    }
}

